@extends('master-app')


@section('contents')

    <div class="container">
           <div class="row justify-content-center">
               <form action="{{route('users.store')}}" method="post">
                   @csrf






                   <div class="row">

                       <div class="col-sm-6">


                           <div class="form-group">



                               <label for="name">Name</label>
                               <input type="text" id="name" class="form-control {{$errors->first('name') ? 'is-invalid' : ''}}" name="name">
                                 <small class="invalid-feedback">{{$errors->first('name')}}</small>




                           </div>



                       </div>










                       <div class="col-sm-6">


                           <div class="form-group">



                               <label for="email">Email</label>
                               <input type="email" id="email" class="form-control {{$errors->first('email') ? 'is-invalid' : ''}}"  name="email">
                               <small class="invalid-feedback">{{$errors->first('email')}}</small>






                           </div>



                       </div>





                       <div class="col-sm-6">


                           <div class="form-group">



                               <label for="password">Password</label>
                               <input type="password" id="password" class="form-control {{$errors->first('password') ? 'is-invalid' : ''}}" name="password">
                               <small class="invalid-feedback">{{$errors->first('password')}}</small>






                           </div>



                       </div>






                       <div class="col-sm-6">


                           <div class="form-group">



                               <label for="role">Status</label>
                               <select name="role_id" id="role" class="form-control">







                                       <option value="0">Not verified</option>
                                       <option value="1">Verified</option>







                               </select>






                           </div>



                       </div>























                   </div>



                   <div class="row" style="display: none" id="com">


                       <div class="col-sm-12" >


                           <div class="form-group">



                               <label for="role">Assign company</label>
                               <select name="company_id" id="companies" class="js-example-basic" style="width: 100%;">

                                   @foreach($companies as $co)





                                       <option value="{{$co->id}}">{{$co->name}}</option>




                                   @endforeach


                               </select>






                           </div>



                       </div>

                   </div>








                   <div class="row">
                       <div class="col-sm-12">
                           <div class="form-group">
                               <button type="submit" class="btn btn-block btn-secondary">Create</button>
                           </div>
                       </div>
                   </div>



               </form>


           </div>
    </div>


















@endsection

@section('scripts')
    <script>

        $('.js-example-basic').select2({padding: '1000px'});




    </script>

    @endsection



@push('scripted')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js" integrity="sha512-2ImtlRlf2VVmiGZsjm9bEyhjGW4dU7B6TNwh/hx/iSByxNENtj3WVE6o/9Lj4TJeVXPi4bnOIMXFIJJAeufa0A==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <script>
        setTimeout(e => {
            const el = document.querySelector('.select2-selection ');
                  el.style.height = '40px';



        }, 10);





        let role = document.getElementById('role');



        role.addEventListener('change', e => {

           Array.from(e.target.options).forEach((item, index) => {







                 if(e.target.options[index].selected) {




                  if(e.target.options[index].value == 3) {

                      $('#com').slideDown();

                  } else {

                      $('#com').slideUp();

                  }






                 }



           });


        });











    </script>






    @endpush



@push('styled')

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" integrity="sha512-nMNlpuaDPrqlEls3IX/Q56H36qvBASwb3ipuo3MxeWbsQB1881ox0cRv7UPTgBlriqoynt35KjEwgGUeUXIPnw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <style>
        /*li.select2-selection__choice {*/
            /*max-width: 100%;*/
            /*overflow: hidden;*/
            /*!*Altered two below to make word wrap work *!*/
            /*word-wrap: normal !important;*/
            /*white-space: normal;*/
        /*}*/
        /*ul.select2-selection__rendered {*/
            /*padding-right: 12px !important;*/
        /*}*/





    </style>



@endpush






@section('header')

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-11">





                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">

                                <h1 class="m-0 text-dark">Users <small>create</small></h1>
                            </div><!-- /.col -->
                            <div class="col-sm-6">
                                <ol class="breadcrumb float-sm-right">
                                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                                    <li class="breadcrumb-item"><a href="{{route('users.index')}}">Users</a></li>
                                    <li class="breadcrumb-item active"> Create</li>





                                </ol>







                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.container-fluid -->
                </div>







            </div>
        </div>
        {{--<a class="btn btn-secondary"  href="{{route('users.create')}}" style="float: right; margin-right: 5%;">--}}
            {{--<i class="fas fa-plus"></i>--}}

            {{--create</a>--}}
        {{--<div style="clear: both;"></div>--}}

    </div>

@endsection



