@extends('app')



@section('content')

    <div class="wrapper">


    @include('layouts.nav')

    <!-- Main Sidebar Container -->
    @include('layouts.sidebar')
    <!-- Content Wrapper. Contains page content -->




        <div class="content-wrapper">
            <!-- Content Header (Page header) -->


        @include('partials.single-table-header')
        <!-- /.content-header -->

            <!-- Main content -->


            <div class="container-fluid mt-5">



                <div class="row justify-content-center">

                    <div class="col-sm-11">







                            <table id="myTable" class="display" >





                                <thead>

                                <tr>
                                    <th>Asset id</th>
                                    <th>Name</th>
                                    <th>Coordinate</th>
                                    <th>Inspection frreq</th>
                                    <th>Next inspection</th>
                                    <th>Priority</th>



                                    @foreach($asset->projects as $pro)
                                    @if($pro->data)

                                        @foreach($pro->data as $k => $v)
                                            <th>{{$k}}</th>


                                        @endforeach



                                    @endif

                                        @break



                                    @endforeach










                                    @if(auth()->user()->hasRole('client'))
                                        <th>View</th>
                                    @else

                                        <th>Actions</th>
                                    @endif





                                </tr>



                                </thead>
                                <tbody>

                                @foreach($asset->projects as $pro)
                                <tr>
                                    <td>{{$pro->asset_id}}</td>
                                    <td>
                                        <a href="{{route('projects.show', $pro->id)}}">
                                            {{$pro->name}}

                                        </a>


                                    </td>
                                    <td>{{$pro->coordinate}}</td>
                                    <td>{{$pro->inspect_freq}}</td>
                                    <td>{{$pro->next_inspect}}</td>


                                    @if($pro->priority === 'high')
                                        <td><button style="width: 100%"  class="btn btn-sm btn-danger">
                                                <i class="fa fa-exclamation-triangle" aria-hidden="true"></i>

                                                {{$pro->priority}}</button></td>



                                    @elseif($pro->priority === 'medium')
                                        <td><button style="width: 100%" class="btn btn-sm btn-warning">

                                                {{$pro->priority}}</button></td>




                                    @elseif($pro->priority === 'low')
                                        <td><button style="width: 100%" class="btn btn-sm btn-secondary">

                                                {{$pro->priority}}</button></td>


                                    @else
                                        <td>-</td>


                                    @endif




                                    @if($pro->data)

                                        @foreach($pro->data as $kk => $vv)

                                            @if($vv)
                                                <td>{{$vv}}</td>
                                            @else
                                                <td>-</td>
                                            @endif



                                        @endforeach



                                    @endif







                                    <td>
                                        <a href="{{route('projects.show', $pro->id)}}">
                                            <i class="fa fa-eye" aria-hidden="true" style="color: darkgreen;"></i>
                                        </a>

                                        @if(!auth()->user()->hasRole('client'))

                                            <i class="fas fa-trash"  onclick="deleteProject({{$pro->id}})" style="color: darkred; cursor: pointer;"

                                            ></i>


                                            <form style="display: none;" action="{{route('projects.destroy', $pro->id)}}" id="pro-{{$pro->id}}" method="POST">
                                                @csrf
                                                @method('delete')


                                            </form>
                                        @endif





                                    </td>
                                </tr>




                                    @endforeach










                                </tbody>
                            </table>















                    </div>



                </div>




            </div>


        {{--@include('layouts.mainContent')--}}



        <!-- /.content -->
        </div>





        <!-- /.content-wrapper -->
    {{--@include('layouts.footer')--}}

    <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>




@endsection






@section('scripts')
    <script>
        function deleteProject(id) {
            let x = confirm('are you sure');

            if(x) {
                document.getElementById('pro-'+id).submit();


            }



        }
    </script>







@endsection




@section('styles')

@endsection








