
   <div style="display: flex; justify-content: end;">
       @if(canEditProject())
       <button  class="btn btn-primary" data-toggle="modal" data-target="#doc-modal">
           <i class="fas fa-plus"   ></i>
           Add
       </button>
           @endif


   </div>





     <div class="modal fade" id="doc-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
         <div class="modal-dialog" role="document">
             <div class="modal-content">
                 <div class="modal-header">
                     <h5 class="modal-title">Add document</h5>

                 </div>
                 <form id="doc-form"  method="post" action="{{route('document.store')}}" enctype="multipart/form-data">
                     <div class="modal-body">
                         @csrf
                         <input type="hidden" name="project_id" value="{{$project->id}}">

                         <div class="form-group">
                             <label for="type" class="col-form-label">Type:</label>
                             <input type="text" class="form-control" id="type" name="type" required>
                         </div>




                         <div class="form-group">


                             <div class="field" align="left">
                                 <h5>Upload document</h5>
                                 <input type="file" onchange="upload_check()" id="document3" name="document"  accept="application/*" required />
                             </div>
                         </div>



                         <div class="form-group">


                             <div class="form-group" id="doc-progress2" style="display: none;">
                                 <label for="upload-bar" class="col-form-label">Uploading...</label>


                                 <div class="progress" id="upload-bar">
                                     <div id="progress2" class="progress-bar progress-bar-striped bg-danger" role="progressbar" style="width: 0%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                 </div>


                             </div>
                         </div>






                     </div>
                     <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                         <button id="send-btn" type="button" onclick="sendForm()" class="btn btn-primary">Submit</button>
                     </div>

                 </form>




             </div>
         </div>
     </div>







    <div style="display: flex; align-items: center; justify-content: center;">
        <h6 class="text-bold">Inspection dcuments</h6>

    </div>

   <table class="table table-hover">
       <thead>
       <tr>
           <th>Document</th>
           <th>File type</th>
           <th>Date</th>
       </tr>
       </thead>
       <tbody>
       @if(count($project->generalDocuments)<1)
           <tr>
               <td>No records found</td>
           </tr>
           @else

       @foreach($project->generalDocuments as $document)
           <tr>
               <td style="width: 33%">

                   @if($document->extension === 'pdf')
                       <i class="fa-solid fa-file-pdf" style="color: darkred"></i>

                   @else
                       <i class="fa-solid fa-file text-warning"></i>


                   @endif

                   <a href="/{{$document->file}}" download>

                       {{substr($document->file, 11)}}

                   </a>

               </td>

               <td style="width: 33%">{{$document->extension}}</td>
               <td style="width: 33%">{{$document->created_at->format('Y-m-d')}}</td>
           </tr>


lor


       @endforeach





         @endif


       </tbody>
   </table>










   <div style="display: flex; align-items: center; justify-content: center;">
       <h6 class="text-bold">General dcuments</h6>

   </div>

   <table class="table table-hover">
       <thead>
       <tr>
           <th>Document</th>
           <th>Type</th>
           <th>File type</th>
           <th>Date</th>
       </tr>
       </thead>
       <tbody>






       @if(count($project->documents)<1)
           <tr>
               <td>No records found</td>
           </tr>
       @else



       @foreach($project->documents as $document)
           <tr>
               <td style="width: 22%">

                   @if($document->document_type === 'pdf')
                       <i class="fa-solid fa-file-pdf" style="color: darkred"></i>

                   @else
                       <i class="fa-solid fa-file text-warning"></i>


                   @endif

                   <a href="/{{$document->file}}" download>

                       {{substr($document->file, 10)}}

                   </a>

               </td>
               <td vstyle="width: 22%">{{$document->type}}</td>
               <td style="width: 22%">{{$document->document_type}}</td>
               <td style="width: 30%">{{$document->created_at->format('Y-m-d')}}</td>
           </tr>





       @endforeach

       @endif






       </tbody>
   </table>











   @push('scripted')

    <script>
        $('#doc-modal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal
            // Extract info from data-* attributes
            // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
            // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
            var modal = $(this)
            modal.find('.modal-title');
            modal.find('.modal-body input');
        });




        const pr = @json($project);
        const progress2 = document.getElementById('progress2');


        let counter2 = 0;

        const imageUploader3 = document.getElementById('document3');




        function upload_check()
        {
            var upl = document.getElementById("document3");


            let max = 20000000;

            if(upl.files[0].size > max)
            {
                alert("File too big!");
                upl.value = "";
            }
        };






        function sendForm() {

            let btn = document.getElementById('send-btn');
            let reader = new FileReader();


            // VALIDATION

            const errors = {};
            let type = document.getElementById('type');
            let doc = document.getElementById('document3');







            if(type.value === "") {
                errors.inspectBy = "input type field is required";
            }



            if(doc.value === "") {
                errors.repairDesc = "upload document field is required";
            }







            for(p in errors) {
                alert(errors[p]);
                return;


            }








            // END VALIDATION








            btn.setAttribute('disabled', true);



            document.getElementById('doc-progress2').style.display = 'block';


            let interval = setInterval(e => {

                counter2++;
                if(counter2 > 98) {
                    counter2 = 1;
                }

                progress2.style.width = counter2+"%";

            }, 500);












            reader.readAsDataURL(imageUploader3.files[0]);
            reader.onload = function(e) {


                // console.log(e.target.result);
                // return;






                axios({
                    method: 'post',
                    url: '/projects/document/all',
                    data: {
                        image: e.target.result,
                        project_id: pr.id,
                        type: type.value,
                    }


                }).
                then(res => {





                    clearInterval(interval);
                    progress2.style.width = "100%";
                    document.getElementById("document3").value = "";
                    document.getElementById('doc-form').submit();











                });










            };














        }

















    </script>


    @endpush