<?php

namespace App\Http\Controllers;

use App\Models\Asset;
use App\Models\Company;
use App\Models\Document;
use App\Models\GeneralDocument;
use App\Models\Project;
use Illuminate\Http\Request;
use DB;
use Illuminate\Routing\Route;
use Illuminate\Http\Response;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $r)
    {

        $pro = DB::update("UPDATE projects SET is_active = 1 WHERE id = :id", ['id' => $r->project_id]);

          $project = Project::find($r->project_id);

           if(!$project) {

               return 0;

           }


        $project->update([
            'name' => $r->name,
            'asset_id' => $r->asset_id,
            'coordinate' => trim($r->coordinate),
            'inspect_freq' => $r->inspect_freq,
            'next_inspect' => $r->next_inspect,
            'data' => $r->data,



        ]);






            return "/c-projects/".$project->id;







    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Project $project)
    {










        if($project->asset->projects()->count() === 0) {
            $isFirst = true;
        } else {
            $isFirst = false;
        }








            $project->data = json_decode($project->data);


            $allPhotos = [];


            foreach($project->inspections()->orderBy('date', 'desc')->get() as $inspection) {

                foreach($inspection->photos as $photo) {

                    $allPhotos[$inspection->date][] = $photo;



                }




            }
























        $companies = Company::all();

        $data = ['project' => $project, 'companies' => $companies, 'allPhotos' => $allPhotos,
                 'isFirst' => $isFirst,


            ];


        return view('projects.show', $data);



    }




    public function showed($id)
    {


        if (!auth()->user()->hasRole('admin')) {
            abort(Response::HTTP_UNAUTHORIZED);


        }



        $project = Project::findOrFail($id);




        if($project->asset->projects()->count() === 0) {
            $isFirst = true;
        } else {
            $isFirst = false;
        }













        $project->data = json_decode($project->data);

        $allPhotos = [];


        foreach($project->inspections()->orderBy('date', 'desc')->get() as $inspection) {

            foreach($inspection->photos as $photo) {

                $allPhotos[$inspection->date][] = $photo;



            }




        }











        $companies = Company::all();

        $data = ['project' => $project, 'companies' => $companies, 'allPhotos' => $allPhotos ,
                 'isFirst' => $isFirst,


        ];


        return view('projects.copy-show', $data);



    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Project $project)
    {
        $project->delete();
        session()->put('info', 'project deleted');
        return back();

    }


    public function updated(Request $r, $id)
    {

       $project = Project::find($id);





       $project->update([

           'name' => $r->name,
          'asset_id' => $r->asset_id,
          'coordinate' => $r->coordinate,
          'inspect_freq' => $r->inspect_freq,
          'next_inspect' => $r->next_inspect,
          'data' => $r->data,


       ]);





        return 1;
    }









    public function uploadDocument(Request $request)
    {
        if ($request->image) {
            $folderPath = "documents/";

            $base64Image = explode(";base64,", $request->image);
            $explodeImage = explode("application/", $base64Image[0]);
            $imageType = $explodeImage[1];



            if($imageType === "vnd.openxmlformats-officedocument.wordprocessingml.document") {

                $imageType = "docx";

            }




            $image_base64 = base64_decode($base64Image[1]);
            $file = $folderPath . uniqid() . '.'.$imageType;

            file_put_contents($file, $image_base64);




//            $project = Project::find($request->project_id);

            GeneralDocument::create([
                'project_id' => $request->project_id,
                'file' => $file,
                  'extension' => $imageType,


            ]);




//            $project->update([
//                'general_document' => $file,
//            ]);

            return "done";




        }


        return 0;
    }




    public function uploadDocumentAll(Request $request)
    {

        if ($request->image) {
            $folderPath = "documents/";

            $base64Image = explode(";base64,", $request->image);
            $explodeImage = explode("application/", $base64Image[0]);
            $imageType = $explodeImage[1];




            if($imageType === "vnd.openxmlformats-officedocument.wordprocessingml.document") {

                $imageType = "docx";

            }




            $image_base64 = base64_decode($base64Image[1]);
            $file = $folderPath . uniqid() . '.'.$imageType;

            file_put_contents($file, $image_base64);



//            $project = Project::find($request->project_id);







            Document::create([
                'project_id' =>  $request->project_id,
                'file' => $file,
                'type' => $request->type,
                 'document_type' => $imageType,





            ]);




//            $project->update([
//                'general_document' => $file,
//            ]);

            return "done";




        }


        return 0;
    }

















    public function uploadImage(Request $request)
    {
        if ($request->image) {
            $folderPath = "project_images/";

            $base64Image = explode(";base64,", $request->image);
            $explodeImage = explode("image/", $base64Image[0]);
            $imageType = $explodeImage[1];
            $image_base64 = base64_decode($base64Image[1]);
            $file = $folderPath . uniqid() . '.'.$imageType;

            file_put_contents($file, $image_base64);




            $project = Project::find($request->project_id);
            $project->update([
                'overview_image' => $file,
            ]);

            return 1;




        }


        return 0;
    }


    public function showSingle($id)
    {



        $asset = Asset::findOrFail($id);



        foreach($asset->projects as $project) {

            $project->data = json_decode($project->data, true);




             $row = DB::select("SELECT * FROM repair_items WHERE project_id = :id AND repairs_identified = 'high'", ['id' => $project->id]);



             if(count($row)>0) {

                 $project->priority  = $row[0]->repairs_identified;

                 continue;


             }




            $row = DB::select("SELECT * FROM repair_items WHERE project_id = :id AND repairs_identified = 'medium'", ['id' => $project->id]);



            if(count($row)>0) {

                $project->priority  = $row[0]->repairs_identified;

                continue;


            }







            $row = DB::select("SELECT * FROM repair_items WHERE project_id = :id AND repairs_identified = 'low'", ['id' => $project->id]);



            if(count($row)>0) {

                $project->priority  = $row[0]->repairs_identified;

                continue;


            }



            $project->priority = null;











        }

















        $companies = Company::all();






        $data = ['asset' => $asset, 'companies' => $companies,



            ];








        return view('projects.single-table', $data );





    }







    public function showSingleMap($id)
    {




        $asset = Asset::findOrFail($id);



        foreach($asset->projects as $project) {

            $project->data = json_decode($project->data);


        }













        $companies = Company::all();

        $data = ['asset' => $asset, 'companies' => $companies];

        return view('projects.single-map', $data );
    }















}
