<?php

namespace App\Http\Controllers;

use App\Models\MiniProject;
use Illuminate\Http\Request;

class MiniProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $r)
    {


        if($r->uid) {

            $mini = MiniProject::where('uid', $r->uid)->first();


            if($mini) {

                $updated = $mini->update([
                    'project_id' => $r->project_id,
                    'title' => $r->title,
                    'data' => json_encode($r->data),

                ]);

                if($updated) {

                    return ['uid' => $mini->uid];


                }

            }



        }


        $uid =  $this->unique_code(20);

        $mini = MiniProject::create([
            'project_id' => $r->project_id,
            'uid' =>  $uid,
            'title' => $r->title,
            'data' => json_encode($r->data),


        ]);

        return ['uid' => $uid];
    }

    function unique_code($limit)
    {
        return substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\MiniProject  $miniProject
     * @return \Illuminate\Http\Response
     */
    public function show(MiniProject $miniProject)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\MiniProject  $miniProject
     * @return \Illuminate\Http\Response
     */
    public function edit(MiniProject $miniProject)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\MiniProject  $miniProject
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MiniProject $miniProject)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\MiniProject  $miniProject
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $mini = MiniProject::where('uid', $id)->first();


        $mini->delete();
        return 1;
    }
}
